#version 330 

uniform sampler2D glowTexture;
uniform bool blurDirection;
in vec4 pos;


void main (void) {
	const int filterKernel = 31; //must be uneven!
	float[(filterKernel+1)/2] gauss;

	float pi = 2.0 * asin(1.0);
	float sigma = 8;
	for(int i =0; i<(filterKernel+1)/2; i++) {
		float exponent = -pow(i/sigma, 2);
		exponent = exponent / 2.0;
		float gaussian = exp(exponent);
		gaussian = (1/ (sigma*sqrt(2*pi)) ) * gaussian;
		gauss[i] =  gaussian;
	}

	vec4 texPos = (pos+1)/2;
	vec4 color = texture2D(glowTexture, texPos.xy) * gauss[0];
	float texOffset; 

	int gaussIndex = 1;
	
	if(blurDirection){
		for(float i = 1; i < (filterKernel-1)/2; i++){
			texOffset = i/1024.0f;
			color += texture2D(glowTexture, vec2(texPos.x-texOffset, texPos.y))*gauss[gaussIndex] + texture2D(glowTexture, vec2(texPos.x+texOffset, texPos.y)) *gauss[gaussIndex];
			gaussIndex++;
		} 
	}else{
		for(float i = 1; i < (filterKernel-1)/2; i++){
			texOffset = i/768.0f;
			color += texture2D(glowTexture, vec2(texPos.x, texPos.y-texOffset))*gauss[gaussIndex] + texture2D(glowTexture, vec2(texPos.x, texPos.y+texOffset)) *gauss[gaussIndex];
			gaussIndex++;
		}
	}
	gl_FragColor =  color;
}