#version 330 

uniform vec4 depthLayer;
in vec2 texCoord;
in vec4 pos;
uniform sampler2D tex;
uniform bool shouldDiscard;

vec4 calcAccumLighting(void);

float computeDepthBlur(float depth){
	float f = (-depth) - depthLayer.y;
	
	if (f > 0 ){
		f = f/depthLayer.x;
	}else{
		f = f/depthLayer.z;
	}
	return (f+1.0f) * 0.5f;
}

void main (void) {
	if(shouldDiscard) {
	gl_FragData[0] = vec4(0,0,0,0);
	
	}
	else {
		gl_FragData[0] = texture2D(tex, texCoord);
		
	}
	
	vec4 color =  texture2D(tex, texCoord);
	color.a = computeDepthBlur(pos.z);
	gl_FragData[1] = color ;
	
}


