// Vertex Shader  file "shadername.vert"

#version 330 core

uniform mat4 cubetranslation_matrix;
uniform mat4 projection_matrix;
uniform mat4 camera_matrix;
uniform mat4 world_translation_matrix;

in  vec4 in_position;
in  vec3 in_normals;
in  vec2 in_textcoords;

out vec2 tex_coord;
out vec3 normals;
out vec3 light_dir;
out vec3 light_dir2;

//out vec3 ex_color;

void main(void)
{
	gl_Position = projection_matrix * camera_matrix * world_translation_matrix * cubetranslation_matrix * in_position;
	tex_coord = vec2(in_textcoords);
	normals = normalize(vec3(camera_matrix * world_translation_matrix * cubetranslation_matrix * vec4(in_normals,0.0)));	
	light_dir = normalize(vec3(camera_matrix *  vec4(0.15,0.1,-1.0,0.0)));
	light_dir2 = normalize(vec3(camera_matrix *  vec4(-0.15,-0.1,1.0,0.0)));
	
	//ex_color = in_color;
	
}
