// Fragment Shader  file "shadername.frag"

#version 330 core
uniform sampler2D Texture0;
uniform bool lightning;

in vec3 normals;
in vec2 tex_coord;
in vec3 light_dir;
in vec3 light_dir2;

//in  vec3 ex_color;
out vec4 out_color;

void main(void)
{
	vec4 color;
	vec4 amb;
	float intensity;
	float intensity2;
	vec3 lightDir;

	color = texture2D(Texture0, tex_coord);

	if (lightning)
	{
		intensity = max(dot(light_dir,normals),0.0);
		intensity2 = max(dot(light_dir2,normals),0.0);
		amb = color * 0.33;

		out_color = (color * intensity) + (vec4(0.8, 0.8, 1.0, 0.0) *  color * intensity2 *0.7);
	}
	else
	{
		out_color = color;
	}

	//out_color = vec4(1.0, 0.0, 0.0, 1.0);
}
