uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

varying vec3 normal, lightDir, halfVector;
varying vec4 diffuse, ambient;

varying vec4 shadowCoord;

void main() {
	// ------ basics ------
	normal = normalize( gl_NormalMatrix * gl_Normal );
	lightDir = normalize( vec3( gl_LightSource[0].position ) );
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
	gl_TexCoord[0] = gl_MultiTexCoord0;

	// ------ colors ------
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient;

	
	// ------ shadow mapping ------
	// scale and bias matrix
	// x/y/z = x/y/z * 0.5 + 0.5 
	// Moving from unit cube [-1,1] to [0,1]
	mat4 bias = mat4(	.5, .0, .0, 0,
						.0, .5, .0, 0,
						.0, .0, .5, 0,
						.5, .5, .5, 1 );

	// mapping coordinates
	shadowCoord = bias * gl_TextureMatrix[1] * modelMatrix * gl_Vertex;
	
	// ------ basics again ------
	gl_FrontColor = gl_Color;
	gl_Position = ftransform();
}