varying vec3 normal, lightDir, halfVector;
varying vec4 diffuse,ambient;
vec3 globalAmbient = vec3( .1, .1, .1 );
float shadowFactor = 0.;

uniform sampler2D diffuseTex;

uniform sampler2D shadowMap;
varying vec4 shadowCoord;
//float epsilon = 0.01;

bool isHiddenBySM( vec4 coords ) {
	if( (coords.s < 0.) || (coords.s > 1.) || (coords.t < 0.) || (coords.t > 1.) )
		return false;
	
	float smDepth = texture2D( shadowMap, coords.st ).z;
	
	smDepth += 0.01;
//	smDepth += 0.008;
	
	return( smDepth < coords.z );
}

void main() {
	// ------ basics ------
	vec3 n = normalize( normal );
	float intensity = max( dot(lightDir, n), 0.0 );

	// ------ shadow map ------
	vec4 mapCoord = shadowCoord / shadowCoord.w;
//	bool shadow = isHiddenBySM(mapCoord);
//	if(  isHiddenBySM( mapCoord ) ) gl_FragColor = vec4( 0., 0., 0., 1. );
//	else gl_FragColor = vec4( 1., 1., 1., 1. );
	
	// ------ specular term ------
	vec4 specular = vec4( 0., 0., 0., 0. );
	if( !isHiddenBySM(mapCoord) )
	{
		shadowFactor = 1.0;
		if ( intensity > 0.0)
		{
			float NdotHV = max(dot( n, normalize(halfVector) ),0.0);
			specular = gl_FrontMaterial.specular * 
				gl_LightSource[0].specular * 
				pow( NdotHV, gl_FrontMaterial.shininess );
		}
	}

		
	// ------ texture ------
	vec4 texel = texture2D( diffuseTex, gl_TexCoord[0].st );
	vec3 ct = texel.rgb;
	float at = texel.a;
	vec3 cf = shadowFactor * (intensity * diffuse.rgb + specular.rgb + ambient.rgb) + globalAmbient;
	float af = diffuse.a;
	
	
	// ------ putting it together ------
	// GL_MODULATE
	//gl_FragColor = vec4(ct * cf, at * af);
	
	// GL_DECAL
	//gl_FragColor = vec4( (ct*at) + (cf*(1.-at)), af);
	
	
	float aa = at + af;
	at = at / aa;
	af = af / aa;
	gl_FragColor = vec4( (ct*at) + (cf*(1.-at)), af);

}