/** \file simpleShadowMapping.frag
 *  
 *  @author Michael May
 *  @date   18.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief simple shadow mapping
 *  needs basicLib.glsl
 */

// defined in basicLib.glsl
//#version 140
//uniform sampler2D shadowMap;

uniform sampler2DShadow shadowMap;

in vec4 ex_mappingCoord;
out vec4 out_Color;

// perspective division (done in textureProj)
vec3 mappingCoord = ex_mappingCoord.stp / ex_mappingCoord.q;

const float shadowValue = 0.; // 0.75;
const float pixelOffset = .0005;

const float epsilon = 0.0001;
//const float epsilon = 0.001;

float lookup( float x, float y ) {
	//float depth = epsilon + texture( shadowMap, mappingCoord.st + vec2( x, y ) * pixelOffset ).z;
	
	//float depth = epsilon + textureProj( shadowMap, ex_mappingCoord + vec4( x, y, 0., 0. ) * pixelOffset );
	float depth = epsilon + texture( shadowMap, mappingCoord.stp + vec3( x, y, 0.) * pixelOffset );

	return ( (depth < mappingCoord.z) ? shadowValue : 1.0 );
}

float lookup( vec2 xy ) {
	return lookup( xy.x, xy.y );
}

void main(void) {
	float shadeFactor = 0.;
	// simple 4 sample anti aliasing
	shadeFactor += lookup( -0.5, -0.5 );
	shadeFactor += lookup(  0.5, -0.5 );
	shadeFactor += lookup( -0.5,  0.5 );
	shadeFactor += lookup(  0.5,  0.5 );
	shadeFactor += lookup(  0.,  0. );
	
	// antialiasing kine to dithering
	//vec2 o = mod( floor( gl_FragCoord.xy), 2.0 );
	//shadeFactor += lookup( vec2(-1.5,  1.5) + o );
	//shadeFactor += lookup( vec2( 0.5,  1.5) + o );
	//shadeFactor += lookup( vec2(-1.5, -0.5) + o );
	//shadeFactor += lookup( vec2( 0.5, -0.5) + o );
	
	shadeFactor *= 0.25;
	
	//vec4 col = vec4( 1., 1., 1., 1. );
	vec4 col = vec4( 0.5, 0.5, 0.5, 1. );
	if( (mappingCoord.s >= 0.) && (mappingCoord.s <= 1.) && (mappingCoord.t >= 0.) && (mappingCoord.t <= 1.) )
	{
		//col = vec4( shadeFactor );

		//if( shadeFactor != 1. )
		//	col = vec4( texture2D( shadowMap, mappingCoord.st ).z );
		//else
		//	col = vec4( mappingCoord.z );

		col = vec4( vec3(shadeFactor), 1. );
	}

	out_Color = col;
}