/** \file default.vert
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief vertex shader (texture, lighting and shadow mapping support)
 *  needs basicLib.glsl
 */

uniform mat4 projTexMatrix;

in vec3 in_Position;
in vec3 in_Color;
in vec3 in_Normal;
in vec2 in_TexCoord0;

out vec4 ex_ecPosition;
out vec3 ex_ecPosition3;
out vec3 ex_Color;
out vec3 ex_Normal;
out vec2 ex_TexCoord0;
out vec4 ex_shadowMappingCoord;

out vec3 ex_worldNormal;
out vec3 ex_worldPos;
out vec3 ex_worldCamDir;
out vec4 ex_reflectDir;

void main(void) {
	ex_TexCoord0 = in_TexCoord0;
	ex_Color = in_Color;

	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	ex_ecPosition = viewMatrix * modelMatrix * vec4(in_Position, 1.0);
	ex_ecPosition3 = (vec3(ex_ecPosition)) / ex_ecPosition.w;
	gl_Position = projMatrix * ex_ecPosition;
	
	ex_Normal = normalize( normalMatrix * in_Normal );

	ex_worldNormal = normalize( mat3(modelMatrix) * in_Normal );
	ex_worldPos = vec3(modelMatrix * vec4(in_Position, 1.));
	ex_worldCamDir = normalize( vec3(modelMatrix * vec4(in_Position, 1.)) - camPos );
	ex_reflectDir = vec4( reflect( ex_worldCamDir, ex_worldNormal ), 1. );

	// *** shadow mapping ***
	// scale and bias matrix
	// x/y/z = x/y/z * 0.5 + 0.5 
	// Moving from unit cube [-1,1] to [0,1] for texture lookup
	mat4 bias = mat4(	.5, .0, .0, 0,
						.0, .5, .0, 0,
						.0, .0, .5, 0,
						.5, .5, .5, 1 );
						
	// mapping coordinates
	ex_shadowMappingCoord = bias * projTexMatrix * modelMatrix * vec4(in_Position, 1.);
}