/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

uniform sampler2D shadowMap;
uniform samplerCube envMap;
//uniform sampler2D envMap;

in vec4 ex_ecPosition;
in vec3 ex_ecPosition3;
in vec3 ex_Normal;
in vec3 ex_Color;
in vec2 ex_TexCoord0;
in vec4 ex_shadowMappingCoord;

in vec3 ex_worldPos;
in vec3 ex_worldNormal;
in vec3 ex_worldCamDir;
in vec4 ex_reflectDir;

out vec4 out_Color;

void main( void ) {
	vec3 amb  = vec3( 0. );
	vec3 diff = vec3( 0. );
	vec3 spec = vec3( 0. );
	float a = FrontMaterial.diffuse.a;	
		
	// our Headlight
	processLight( LightSource[ 0 ], ex_ecPosition3, ex_Normal, 1., amb, diff, spec );
			
	vec3 frontColor = amb  * vec3( FrontMaterial.ambient ) +
					  diff * vec3( FrontMaterial.diffuse );
	
	//vec3 reflectDir = reflect( normalize(ex_worldCamDir), normalize(ex_worldNormal) );
	vec3 reflectDir = reflect( normalize(ex_worldPos - camPos), normalize(ex_worldNormal) );

	vec4 texel = texture( envMap, reflectDir );
	//vec4 texel = texture( envMap, ex_worldCamDir );
	//vec4 texel = texture( envMap, reflect( ex_worldCamDir, ex_worldNormal ) );
				
	//frontColor = (frontColor + vec3(texel)) / 2.;

	// GL_REPLACE
	//frontColor = vec3( texel );
	// * GL_MODULATE
	frontColor *= vec3( texel );
	//a *= texel.a;
	
	out_Color = vec4( frontColor, a );

//	out_Color = vec4( ex_reflectDir.xyz, 1. );
//	out_Color = vec4( reflectDir, 1. );
//	out_Color = vec4( ex_worldCamPos, 1. );
//	out_Color = vec4( ex_worldNormal, 1. );
//	out_Color = vec4( reflect( ex_worldCamPos, ex_worldNormal ), 1. );

//	out_Color = vec4( (frontColor + frontSecondaryColor), a );
//	out_Color = vec4( vec3(shadeValue), 1. );
//	out_Color = vec4( ex_Normal, 1. );
}
