/** \file simpleProjTex.vsh
 *
 *  @author	Michael May
 *  @date	18.01.10
 *
 *  Copyright (C) 2010
 *
 *  @brief simple projective texturing
 */
 
 // defined in basicLib.glsl
//#version 140
//uniform mat4 projMatrix, viewMatrix, modelMatrix;
uniform mat4 projTexMatrix;

in vec3 in_Position;
out vec4 ex_mappingCoord;

void main(void) {
	// scale and bias matrix
	// x/y/z = x/y/z * 0.5 + 0.5 
	// Moving from unit cube [-1,1] to [0,1] for texture lookup
	mat4 bias = mat4(	.5, .0, .0, 0,
						.0, .5, .0, 0,
						.0, .0, .5, 0,
						.5, .5, .5, 1 );
						
	// mapping coordinates
	ex_mappingCoord = bias * projTexMatrix * modelMatrix * vec4(in_Position, 1.);
	
	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	gl_Position = projMatrix * viewMatrix * modelMatrix * vec4(in_Position, 1.0);
}