/** \file simpleProjTex.fsh
 *
 *  @author	Michael May
 *  @date	18.01.10
 *
 *  Copyright (C) 2010
 *
 *  @brief simple projective texturing
 */

//#version 140
//uniform sampler2D tex1;

in vec4 ex_mappingCoord;
out vec4 out_Color;

void main(void) {
	// perspective division
	vec4 mappingCoord = ex_mappingCoord / ex_mappingCoord.q;
	
	vec4 col = vec4( 0., 0., 0., 1. );
	if( (mappingCoord.s >= 0.) && (mappingCoord.s <= 1.) && (mappingCoord.t >= 0.) && (mappingCoord.t <= 1.) )
		col = texture2D( tex1, mappingCoord.st );

	//if( (col.z < -1.) || (col.z > 1.) ) col = vec4( 1., 0., 0., 1. );
	//else if( col.z < 0. ) col = vec4( 0., 1., 0., 1. );
	//else col = vec4( 0., 0., 1., 1. );
	out_Color = col;
}