/** \file default.vert
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief vertex shader (texture, lighting and shadow mapping support)
 *  needs basicLib.glsl
 */

uniform mat4 projTexMatrix;

in vec3 in_Position;
in vec3 in_Color;
in vec3 in_Normal;
in vec2 in_TexCoord0;

out vec4 ex_ecPosition;
out vec3 ex_ecPosition3;
out vec3 ex_Color;
out vec3 ex_Normal;
out vec2 ex_TexCoord0;

void main(void) {
	ex_TexCoord0 = in_TexCoord0;
	ex_Color = in_Color;

	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	ex_ecPosition = viewMatrix * modelMatrix * vec4(in_Position, 1.0);
	ex_ecPosition3 = (vec3(ex_ecPosition)) / ex_ecPosition.w;
	gl_Position = projMatrix * ex_ecPosition;
	
	ex_Normal = normalize( normalMatrix * in_Normal );	
}