/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

in vec4 ex_ecPosition;
in vec3 ex_ecPosition3;
in vec3 ex_Normal;
in vec3 ex_Color;
in vec2 ex_TexCoord0;

out vec4 out_Color;

void main( void ) {
	vec3 amb  = vec3(0.);
	vec3 diff = vec3(0.);
	vec3 spec = vec3(0.);
	float a = FrontMaterial.diffuse.a;
	
	processLights( ex_ecPosition3, ex_Normal, amb, diff, spec );
	
	vec3 frontColor = amb  * vec3( FrontMaterial.ambient ) +
					  diff * vec3( FrontMaterial.diffuse );
	vec3 frontSecondaryColor = spec * vec3( FrontMaterial.specular );
	
	if( FrontMaterial.diffuseTextureAvailable ) {
		vec4 texel = texture2D( diffuseTex, ex_TexCoord0.st );

		// GL_REPLACE
		//frontColor = texel;
		// * GL_MODULATE
		frontColor *= vec3( texel );
		a *= texel.a;
		// * GL_DECAL
		//frontColor = vec4( mix( frontColor.rgb, texel.rgb, texel.a ), frontColor.a );
		// * GL_ADD
		//frontColor.rgb += texel.rgb;
		//frontColor.a *= texel.a;
		//frontColor = clamp( frontColor, 0., 1. );
	}

	if( a == 0. ) discard;
	out_Color = vec4( (frontColor + frontSecondaryColor), a );
}