/** \file default.vert
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple vertex shader
 *  needs basicLib.glsl
 */
 
in vec3 in_Position;
in vec3 in_Color;
in vec3 in_Normal;
in vec2 in_TexCoord0;

out vec3 ex_Color;
out vec3 ex_LightDir;
out vec3 ex_Normal;
out vec2 ex_TexCoord0;

void main(void) {
	// TEXTURES
	ex_TexCoord0 = in_TexCoord0;
	
	// LIGHTING
	ex_Normal = normalize( normalMatrix * in_Normal );
	ex_LightDir = normalize( vec3( LightSource[0].position ) );
	
	// basics
	ex_Color = in_Color;
	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	gl_Position = projMatrix * viewMatrix * modelMatrix * vec4(in_Position, 1.0);
}