/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

in vec3 ex_LightDir;
in vec3 ex_Normal;
in vec3 ex_Color;
in vec2 ex_TexCoord0;

vec4 color;
out vec4 out_Color;

void main(void) {
	vec4 texel = texture2D( diffuseTex, ex_TexCoord0.st );
	vec3 ct = texel.rgb;
	float at = texel.a;	
	
	// TIP: calculate halfvector with 'reflect( I, N );'
	
	float intensity = max( dot( ex_LightDir, normalize(ex_Normal)), 0.0 );
	vec3 cf = intensity * ( FrontMaterial.diffuse.rgb ) + 
					  FrontMaterial.ambient.rgb;
	float af = FrontMaterial.diffuse.a;
	
	// GL_REPLACE
	//color = texel;
	// GL_MODULATE
	color = vec4(ct * cf, at * af);
	// GL_DECAL
	//color = vec4( mix( cf, ct, at ), af ); // mix = cf*(1-at)+ct*at
	
	//color = vec4( cf, af );
	//color = FrontMaterial.diffuse;
	//color = vec4( ex_Color, 1.0 );

	if( color.a == 0. ) discard;
	out_Color = color;
}