/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

uniform sampler2D shadowMap;
uniform samplerCube envMap;
uniform sampler2D cloudShadowMap;
uniform sampler2D waveBumpMap;
uniform mat4 projTexMatrix;

in vec4 ex_wcPosition;
in vec4 ex_ecPosition;
in vec3 ex_ecPosition3;

in vec3 ex_wcNormal;
//out vec3 ex_ecNormal;

in vec3 ex_Color;
in vec2 ex_TexCoord0;
in vec4 ex_shadowMappingCoord;

out vec4 out_Color;

void main( void ) {
	vec3 amb  = vec3( 0. );
	vec3 diff = vec3( 0. );
	vec3 spec = vec3( 0. );
	float a = FrontMaterial.diffuse.a;
	
	// bump map
	vec3 bmNormal = normalize( -.5 + texture2D( waveBumpMap, ex_wcPosition.xz / 100. + timer / 100. ).rbg);
	vec3 wcBumpNormal = normalize( mat3(modelMatrix) * bmNormal );
	vec3 ecBumpNormal = normalize( normalMatrix * bmNormal );
	vec4 wcBumpPos = ex_wcPosition -
		vec4(wcBumpNormal.x/wcBumpNormal.y, 0., wcBumpNormal.z/wcBumpNormal.y, 0.);

	// shadow mapping coordinates
	mat4 bias = mat4( .5, .0, .0, 0, .0, .5, .0, 0, .0, .0, .5, 0, .5, .5, .5, 1 );
	vec4 shadowMappingCoord = bias * projTexMatrix * wcBumpPos;
	vec3 smCoord = shadowMappingCoord.stp / shadowMappingCoord.q;

	// process shadow
	float shadeValue = getShadeFactorAA( shadowMap, smCoord );

	// cloud shadows
	vec2 cloudShadeCoord = wcBumpPos.xz / 200. + timer / 100.;
	float cloudShadeValue = texture2D( cloudShadowMap, cloudShadeCoord ).r;
	shadeValue *= 1 - cloudShadeValue * .5;

	// Sun Light
	processLight( LightSource[ 0 ], ex_ecPosition3, ecBumpNormal,
					shadeValue, amb, diff, spec );
			
	// our Headlight
	processLight( LightSource[ 1 ], ex_ecPosition3, ecBumpNormal, 1., amb, diff, spec );

	vec3 frontColor = vec3( globalAmbient ) +
					  amb  * vec3( FrontMaterial.ambient ) +
					  diff * vec3( FrontMaterial.diffuse );
	
	vec3 reflectDir = reflect( normalize(ex_wcPosition.xyz - camPos), wcBumpNormal );

	vec4 texel = texture( envMap, reflectDir );
				
	// * GL_MODULATE
	frontColor *= vec3( texel );
	
	vec3 frontSecondaryColor = spec * vec3( FrontMaterial.specular );
	out_Color = vec4( (frontColor + frontSecondaryColor), a );
//	out_Color = vec4( frontColor, a );
//	out_Color = vec4( wcBumpNormal, 1. );
//	out_Color = vec4( ecBumpNormal, 1. );
//	out_Color = vec4( vec3( ex_wcNormal ), 1. );
//	out_Color = vec4( vec3( ex_ecNormal ), 1. );
//	out_Color = vec4( bmNormal, 1. );
}
