/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

uniform sampler2D shadowMap;
uniform sampler2D cloudShadowMap;

in vec4 ex_wcPosition;
in vec4 ex_ecPosition;
in vec3 ex_ecPosition3;
in vec3 ex_ecNormal;
in vec3 ex_Color;
in vec2 ex_TexCoord0;
in vec4 ex_shadowMappingCoord;

out vec4 out_Color;

void main( void ) {
	vec3 amb  = vec3( 0. );
	vec3 diff = vec3( 0. );
	vec3 spec = vec3( 0. );
	float a = FrontMaterial.diffuse.a;
	vec3 smCoord = ex_shadowMappingCoord.stp / ex_shadowMappingCoord.q;
	
	// process shadow
	//float shadeValue = getShadeFactorAA( shadowMap, smCoord );
	float shadeValue = getShadeFactorD( shadowMap, smCoord );
	
	// cloud shadows
	vec2 cloudShadeCoord = ex_wcPosition.xz / 200. + timer / 100.;
	float cloudShadeValue = texture2D( cloudShadowMap, cloudShadeCoord ).r;
	shadeValue *= 1 - cloudShadeValue * .5;

	// Sun Light
	processLight( LightSource[ 0 ], ex_ecPosition3, ex_ecNormal,
					shadeValue, amb, diff, spec );

	// our Headlight
	processLight( LightSource[ 1 ], ex_ecPosition3, ex_ecNormal, 1., amb, diff, spec );
		
	vec3 frontColor = vec3( globalAmbient ) +
					  amb  * vec3( FrontMaterial.ambient ) +
					  diff * vec3( FrontMaterial.diffuse );
	
	if( FrontMaterial.diffuseTextureAvailable ) {
		vec4 texel = texture2D( diffuseTex, ex_TexCoord0.st );

		// GL_REPLACE
		//frontColor = texel;
		// * GL_MODULATE
		frontColor *= vec3( texel );
		a *= texel.a;
		// * GL_DECAL
		//frontColor = vec4( mix( frontColor.rgb, texel.rgb, texel.a ), frontColor.a );
		// * GL_ADD
		//frontColor.rgb += texel.rgb;
		//frontColor.a *= texel.a;
		//frontColor = clamp( frontColor, 0., 1. );
	}

	vec3 frontSecondaryColor = spec * vec3( FrontMaterial.specular );
	
	out_Color = vec4( (frontColor + frontSecondaryColor), a );
//	out_Color = vec4( shadeValue );
//	out_Color = vec4( smCoord, 1. );
//	out_Color = vec4( vec3(cloudShadeValue), 1. );

//	if( out_Color.a == 0 ) discard;
}
