/** \file createShadowMap.vsh
 *
 *  @author	Michael May
 *  @date	08.01.10
 *
 *  Copyright (C) 2010
 *
 *  @brief create depth texture
 *  using same calculations as in the actual shadowmapping
 *  needs basicLib.glsl
 */

in vec3 in_Position;
in vec2 in_TexCoord0;

out vec4 ex_position;
out vec2 ex_TexCoord0;

void main(void) {
//// scale and bias matrix
	//// x/y/z = x/y/z * 0.5 + 0.5 
	//// Moving from unit cube [-1,1] to [0,1]
	mat4 bias = mat4(	.5, .0, .0, 0,
						.0, .5, .0, 0,
						.0, .0, .5, 0,
						.5, .5, .5, 1 );
						
	ex_position = bias * projMatrix * viewMatrix * modelMatrix * vec4(in_Position, 1.);
	
	// TEXTURES
	ex_TexCoord0 = in_TexCoord0;
	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	gl_Position = projMatrix * viewMatrix * modelMatrix * vec4(in_Position, 1.0);
}