/** \file createShadowMap.fsh
 *
 *  @author	Michael May
 *  @date	08.01.10
 *
 *  Copyright (C) 2010
 *
 *  @brief create depth texture
 *  needs basicLib.glsl
 */

in vec4 ex_position;
in vec2 ex_TexCoord0;

out vec4 out_Color;

void main(void) {
	// check if fragment is fully transparent
	if( FrontMaterial.diffuseTextureAvailable ) {
		vec4 texel = texture2D( diffuseTex, ex_TexCoord0.st );
		if( (texel.a == 0.) ) discard;
	}

	// perspective division
	//out_Color = ex_position / ex_position.w;
	float v = ex_position.z / ex_position.w;
	out_Color = vec4( v, v, v, 1. );

	//		gl_FragCoord	ex_position
	// x	0. - resX		0. - 1.
	// y	0. - resY		0. - 1.
	// z	0. - 1.			0. - 1.
	// x and y from gl_FragCoord seem strangly non linear
	// heard the same about it's z coord

	// --------- testing ex_position ----------
	// perspective division
	//float v = ex_position.x / ex_position.w;
	//float v = ex_position.y / ex_position.w;
	//if( (v < .1) || (v > .9) ) out_Color = vec4( 1., 0., 0., 1. );
	//else if( v < 0.5 ) out_Color = vec4( 0., 1., 0., 1. );
	//else out_Color = vec4( 0., 0., 1., 1. );

	// perspective division
	//float v = ex_position.z / ex_position.w;
	//if( (v < .9) || (v > .999) ) out_Color = vec4( 1., 0., 0., 1. );
	
	//else out_Color = vec4( (v-.9) / .099 );
	
	//else if( v < 0.995 ) out_Color = vec4( 0., 1., 0., 1. );
	//else out_Color = vec4( 0., 0., 1., 1. );

	// --------- testing gl_FragCoord ----------
	//const float resX = 800;
	//float col = gl_FragCoord.x; // screen coordinates
	//if( (col < 10.) || (col > resX - 10.) ) out_Color = vec4( 1., 0., 0., 1. );
	//else if( col < resX/2. ) out_Color = vec4( 0., 1., 0., 1. );
	//else out_Color = vec4( 0., 0., 1., 1. );

	//const float resY = 600;
	//float col = gl_FragCoord.y; // screen coordinates
	//if( (col < 10.) || (col > resY - 10.) ) out_Color = vec4( 1., 0., 0., 1. );
	//else if( col < resY/2. ) out_Color = vec4( 0., 1., 0., 1. );
	//else out_Color = vec4( 0., 0., 1., 1. );
	
	//float col = gl_FragCoord.z; // * gl_FragCoord.w;
	//if( (col < 0.9) || (col > .999) ) out_Color = vec4( 1., 0., 0., 1. );
	//else if( col < .995 ) out_Color = vec4( 0., 1., 0., 1. );
	//else out_Color = vec4( 0., 0., 1., 1. );

}