/** \file default.vert
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  This file is part of "project".
 *  Copyright (C) 2009
 *
 *  @brief a simple vertex shader
 *  needs basicLib.glsl
 */

in vec3 in_Position;
in vec3 in_Color;
in vec3 in_Normal;

out vec3 ex_Color;
out vec3 ex_LightDir;
out vec3 ex_Normal;

void main(void) {	
	// LIGHTING
	ex_Normal = normalize( normalMatrix * in_Normal );
	ex_LightDir = normalize( vec3(LightSource[0].position) );
//	ex_LightDir = normalize( vec3( 0., 0., 1. ) ); // head light :)
	
	// basics
	ex_Color = in_Color;
	// Projection Coords <- Viewing Coords <- World Coords <- Modelling Coords
	gl_Position = projMatrix * viewMatrix * modelMatrix * vec4(in_Position, 1.0);
}