/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  This file is part of "project".
 *  Copyright (C) 2009
 *
 *  @brief a simple fragment shader
 *  needs basicLib.glsl
 */

in vec3 ex_LightDir;
in vec3 ex_Normal;
in vec3 ex_Color;

out vec4 out_Color;

void main(void) {
	// TIP: calculate halfvector with 'reflect( I, N );'
	
	vec4 amb = FrontMaterial.ambient;
	vec4 diff = vec4(ex_Color, 1.) * FrontMaterial.diffuse;
	vec4 spec = FrontMaterial.specular;
	
	float intensity = max( dot( ex_LightDir, normalize(ex_Normal)), 0.0 );
	vec3 cf = intensity * ( diff.rgb ) + 
					  amb.rgb;
	float af = diff.a;
	
	out_Color = vec4( cf, af );
	//out_Color = FrontMaterial.diffuse;
	//out_Color = vec4( ex_Color, 1.0 );
}