/** \file default.frag
 *  
 *  @author Michael May
 *  @date   06.02.10
 *
 *  Copyright (C) 2009
 *
 *  @brief a simple shader to render a SkyBox
 *  needs basicLib.glsl
 */

in vec3 ex_LightDir;
in vec3 ex_Normal;
in vec3 ex_Color;
in vec2 ex_TexCoord0;

out vec4 out_Color;

void main(void) {
	vec4 texel = texture2D( diffuseTex, ex_TexCoord0.st );
	vec3 ct = texel.rgb;
	float at = texel.a;	
	
	// TIP: calculate halfvector with 'reflect( I, N );'
	
	float intensity = max( dot( ex_LightDir, normalize(ex_Normal)), 0.0 );
	vec3 cf = intensity * ( FrontMaterial.diffuse.rgb ) + 
					  FrontMaterial.ambient.rgb;
	float af = FrontMaterial.diffuse.a;
	
	// GL_REPLACE
	//out_Color = texel;
	// GL_MODULATE
	out_Color = vec4(ct * cf, at * af);
	// GL_DECAL
	//out_Color = vec4( mix( cf, ct, at ), af ); // mix = cf*(1-at)+ct*at
	
	//out_Color = vec4( cf, af );
	//out_Color = FrontMaterial.diffuse;
	//out_Color = vec4( ex_Color, 1.0 );
}