#include <stdio.h>
#include <math.h>
#include "../headers/MVector4.h"


MVector4 :: MVector4(void) {
	x = y = z = w = 0;
}

MVector4 :: MVector4(float _x, float _y, float _z, float _w) {
	x = _x;
	y = _y;
	z = _z;
	w = _w;
}

float MVector4 :: qlength(void) {
	return x*x+y*y+z*z+w*w;
}

float MVector4 :: length(void) {
	return sqrtf(x*x+y*y+z*z+w*w);
}

void MVector4 :: normalize(void) {
	float s = length();
	if (s != 0.0f) {
		x /= s;
		y /= s;
		z /= s;
		w /= s;
	}
}

MVector4 MVector4 :: operator*(const float& s) {
	return MVector4(x*s,y*s,z*s,w*s);
}

MVector4& MVector4 :: operator*=(const float& s) {
	x *= s;
	y *= s;
	z *= s;
	w *= s;
	return *(this);
}

MVector4& MVector4 :: operator*=(const double& s) {
	x *= (float)s;
	y *= (float)s;
	z *= (float)s;
	return *(this);
}

MVector4 MVector4 :: operator/(const float& s) {
	return MVector4(x/s,y/s,z/s,w/s);
}

MVector4 MVector4 :: operator+(MVector4& v) {
	return MVector4(x+v.x,y+v.y,z+v.z,w+v.w);
}

MVector4 MVector4 :: operator-(void) {
	return MVector4(-x,-y,-z,-w);
}

MVector4 MVector4 :: operator-(MVector4& v) {
	return MVector4(x-v.x,y-v.y,z-v.z,w-v.w);
}

MVector4& MVector4 :: operator+=(MVector4& v) {
	x += v.x;
	y += v.y;
	z += v.z;
	w += v.w;
	return *(this);
}

MVector4& MVector4 :: operator-=(MVector4& v) {
	x -= v.x;
	y -= v.y;
	z -= v.z;
	w -= v.w;
	return *(this);
}

bool MVector4 :: operator==(MVector4& v) {
	return (x==v.x && y==v.y && z==v.z && w == v.w);
}

bool MVector4 :: operator!=(MVector4& v) {
	return (x!=v.x || y!=v.y || z!=v.z || w!=v.w);
}

MVector4& MVector4 :: operator=(MVector3& v) {
    x = v.x;
    y = v.y;
    z = v.z;
    return *(this);
}

MVector4& MVector4 :: operator=(double* arr) {
	x = (float)arr[0];
	y = (float)arr[1];
	z = (float)arr[2];
	w = 1.0f;
	return *(this);
}

MVector4 :: operator float*() {
	float* temp = new float[4];
	temp[0] = x;
	temp[1] = y;
	temp[2] = z;
	temp[3] = w;
	return temp;
}

float MVector4 :: dot(MVector4& v) {
	return (w*v.w)+(x*v.x)+(y*v.y)+(z*v.z);
}

void MVector4 :: print(void) {
	printf("( %f %f %f %f )\n",w,x,y,z);
}
