#include <stdio.h>
#include <math.h>
#include "../headers/MVector3.h"

MVector3 :: MVector3(void) {
	x = y = z = 0;
}

MVector3 :: MVector3(float _x, float _y, float _z) {
	x = _x;
	y = _y;
	z = _z;
}

float MVector3 :: qlength(void) {
	return x*x+y*y+z*z;
}

float MVector3 :: length(void) {
	return sqrtf(x*x+y*y+z*z);
}

void MVector3 :: normalize(void) {
	float s = length();
	if (s != 0.0f) {
		x /= s;
		y /= s;
		z /= s;
	}
}

MVector3 MVector3 :: operator*(const float& s) {
	return MVector3(x*s,y*s,z*s);
}

MVector3& MVector3 :: operator*=(const float& s) {
	x *= s;
	y *= s;
	z *= s;
	return *(this);
}

MVector3 MVector3 :: operator/(const float& s) {
	return MVector3(x/s,y/s,z/s);
}

MVector3 MVector3 :: operator+(MVector3 v) {
	return MVector3(x+v.x,y+v.y,z+v.z);
}

MVector3 MVector3 :: operator-(void) {
	return MVector3(-x,-y,-z);
}

MVector3 MVector3 :: operator-(MVector3 v) {
	return MVector3(x-v.x,y-v.y,z-v.z);
}

MVector3& MVector3 :: operator+=(MVector3 v) {
	x += v.x;
	y += v.y;
	z += v.z;
	return *(this);
}

MVector3& MVector3 :: operator-=(MVector3 v) {
	x -= v.x;
	y -= v.y;
	z -= v.z;
	return *(this);
}

bool MVector3 :: operator==(MVector3 v) {
	return (x==v.x && y==v.y && z==v.z);
}

bool MVector3 :: operator!=(MVector3 v) {
	return (x!=v.x || y!=v.y || z!=v.z);
}

MVector3 :: operator float*() {
	float* temp = new float[3];
	temp[0] = x;
	temp[1] = y;
	temp[2] = z;
	return temp;
}

float MVector3 :: dot(MVector3 v) {
	return (x*v.x)+(y*v.y)+(z*v.z);;
}

MVector3 MVector3 :: cross(MVector3 v) {
	return MVector3(y*v.z - z*v.y, z*v.x - x*v.z, x*v.y - y*v.x);
}

void MVector3 :: print(void) {
	printf("( %f %f %f )\n",x,y,z);
}
