#include <stdio.h>

#include "../headers/MInterpolatedScalar.h"

float MInterpolatedScalar::valuesLin[16] = { 0.0625f, 0.125f, 0.1875f, 0.25f, 0.3125f, 0.375f, 0.4375f, 0.5f, 0.5625f, 0.625f, 0.6875f, 0.75f, 0.8125f, 0.875f, 0.9375f, 1.0f};
float MInterpolatedScalar::valuesGauss[15] = { 0.0f, 0.0002f, 0.0013f, 0.0082f, 0.0359f, 0.1151f, 0.2743f, 0.5f, 0.7257f, 0.8849f, 0.9641f, 0.9918f, 0.9987f, 0.9998f, 1.0f };

MInterpolatedScalar::MInterpolatedScalar(unsigned char interpolationType) {
	i=0;
	switch(interpolationType) {
		case INTER_GAUSS:
			values = MInterpolatedScalar::valuesGauss;
			valuesLength = 15;
		break;
		
		case INTER_LIN:
		default:
			values = MInterpolatedScalar::valuesLin;
			valuesLength = 16;
		break;
	}
}

MInterpolatedScalar::~MInterpolatedScalar(void) {
}

float MInterpolatedScalar::next() {
	if(i<valuesLength) {
		i++;
	}
	return values[i-1];
}

bool MInterpolatedScalar::hasNext() {
	return i<valuesLength;
}

void MInterpolatedScalar::reset() {
	i=0;
}
