#ifndef MAIN_H
#define MAIN_H

#include <list>
#include <NxPhysics.h>
#include "../headers/Character.h"
#include "../headers/GeCamera.h"
#include "../headers/GeMesh.h"
#include "../headers/GeHudText.h"
#include "../headers/GeBranchShader.h"
#include "../headers/FBXWrapper.h"
#include "../headers/MeshManager.h"

#ifdef MAIN_CPP
	#define EXTERN
#else
	#define EXTERN extern
#endif

// in seconds, maximum 20ms !!
#define UPDATE_INTERVAL		0.02f //1/60.0f

EXTERN void update_main(double diff);
EXTERN void closeGame();
EXTERN GeHudText *hudFps;
EXTERN GeHudText *hudInfoText;
EXTERN std::list<GeLight*> lights;
EXTERN Character *character;
EXTERN GeCamera *cam;
EXTERN GeBranchShader *branchShader;
EXTERN FBXWrapper fbx;
EXTERN GeBranch objects;
EXTERN MeshManager* meshMan;

#undef EXTERN
#endif MAIN_H