#ifndef SETTINGS_H
#define SETTINGS_H

#include <stdio.h>

#define FLAG_FULLSCREEN				0x01
#define FLAG_SHOW_FPS				0x02
#define FLAG_WIREFRAME				0x04
#define FLAG_TEXTUREQUALITY_HIGH	0x08
#define FLAG_VIEWFRUSTUM_CULLING	0x10
#define FLAG_TRANSPARENCY			0x20
#define FLAG_SHOW_BOUNDING			0x40
#define FLAG_USE_DISPLAY_LISTS		0x80
#define FLAG_USE_CUSTOM_SHADER		0x100
#define FLAG_VOLUME_SHADOWS			0x200

// OFF
#define MIPMAP_MODE_OFF 0
// Nearest Neighbour
#define MIPMAP_MODE_NN	1
// Linear
#define MIPMAP_MODE_LIN 2

// use immediate mode
#define RENDER_IMMEDIATE	0
// use vertex arrays
#define RENDER_VERTEX_ARRAY 1
// use vertex buffer objects
#define RENDER_VBO			2

class Settings {

public:
	void saveSettings();
	bool loadSettings();
	void loadDefaultSettings();

	int flags;
	unsigned char mipmapMode;
	unsigned char renderMode;
	unsigned int width;
	unsigned int height;
	float viewRatio;
	unsigned int depth;
	unsigned int frequency;
	unsigned int updateInterval; // in millisecounds
	unsigned int halfWidth;
	unsigned int halfHeight;

private:
	void getValueByKey(FILE* fp, char* val, char* key);
	int getIntByVal(FILE* fp, char* key);

};

#ifdef MAIN_CPP
	Settings settings;
#else
	extern Settings settings;
#endif

#endif
