#ifndef MESHMANAGER_H
#define MESHMANAGER_H

#include <map>
#include <string>
#include <NxPhysics.h>
#include "ActorPrototype.h"
#include "GeBlendableMesh.h"
#include "GeActor.h"


class MeshManager {
private:
	string folder;
	map<string, ActorPrototype> actorMap;

public:
	MeshManager(string folder);
	~MeshManager();

	GeActor* getActor(string name, bool staticActor=false);
	GeBlendableMesh* getBlendableActor(string name, bool staticActor=false);
};

#endif