#ifndef MVECTOR4_H
#define MVECTOR4_H
#include "MVector3.h"

class MVector4 {
public:
	union { float x; float r; };
	union { float y; float g; };
	union { float z; float b; };
	union { float w; float a; };
	
	MVector4(void);
	MVector4(float _x, float _y, float _z, float _w);
	
	inline float qlength(void); // quadratic length
	inline float length(void);
	inline void normalize(void);

	MVector4 operator*(const float& s);
	MVector4& operator*=(const float& s);
	MVector4& operator*=(const double& s);
	MVector4 operator/(const float& s);
	MVector4 operator+(MVector4& v);
	MVector4& operator+=(MVector4& v);
	MVector4 operator-(void);
	MVector4 operator-(MVector4& v);
	MVector4& operator-=(MVector4& v);
	MVector4& operator=(MVector3& v);
	MVector4& operator=(double* arr);
	bool operator==(MVector4& v);
	bool operator!=(MVector4& v);
	operator float*();
	
	float dot(MVector4& v);

	void print(void);
};


typedef MVector4 MColor4;

#endif
