#ifndef MVECTOR3_H
#define MVECTOR3_H

class MVector3 {
public:
	union { float x; float r; };
	union { float y; float g; };
	union { float z; float b; };

	MVector3(void);
	MVector3(float _x, float _y, float _z);
	
	float qlength(void); // quadratic length
	float length(void);
	void normalize(void);

	MVector3 operator*(const float& s);
	MVector3& operator*=(const float& s);
	MVector3 operator/(const float& s);
	MVector3 operator+(MVector3 v);
	MVector3& operator+=(MVector3 v);
	MVector3 operator-(void);
	MVector3 operator-(MVector3 v);
	MVector3& operator-=(MVector3 v);
	bool operator==(MVector3 v);
	bool operator!=(MVector3 v);
	operator float*();
	
	float dot(MVector3 v);
	MVector3 cross(MVector3 v);

	void print(void);
};

typedef MVector3 MPoint;
typedef MVector3 MColor3;

#endif
