#ifndef GETEXTURE_H
#define GETEXTURE_H
#include <string>
#include <map>
#include "oglheaders.h"

using namespace std;

class GeTexture {
private:
	GLuint width, height, textureid;
	bool valid, highQuality;
	GLuint mipmapQuality;

	static map<string, GeTexture*> textureMap;

	GLuint getMode(void);
	GeTexture(const char* filename);
	
public:
	static GeTexture* getTexture(const char* filename);
	static void freeTextures(void);

	~GeTexture();

	void bind(void);
	static inline void unbind(void) {
		glBindTexture(GL_TEXTURE_2D, 0);
	};


	unsigned int getWidth(void);
	unsigned int getHeight(void);
};
#endif