#ifndef GEMESHRENDERER_H
#define GEMESHRENDERER_H
#include "oglheaders.h"
#include "GeGeometry.h"
#include "../headers/PhysXWrapper.h"

class GeMeshRenderer {

private:	
    inline void renderMeshImmediate(void);
	inline void renderMeshVertexArray(void);
	inline void renderMeshVBO(void);

	void zPassShadow(GeLight* light, float* globalPoseMat);
	void zFailShadow(GeLight* light, float* globalPoseMat);
	void drawShadowVolume(GeLight* light, float* globalPoseMat, bool drawLightCap, bool drawDarkCap);
	void drawSides(int lightIndex);
	void drawLightCap(int lightIndex);
	void drawDarkCap(int lightIndex);

public:
	GeMeshRenderer(GeMeshRenderer* meshRenderer);
	GeMeshRenderer(GeGeometry* geometry);
	~GeMeshRenderer(void);
	
	void render(void);
	void shadowPass(GeLight* light, float* globalPoseMat);	
	void computeSilhouetteEdges(NxVec3 lightPos, int lightIndex);
	void extrudeSilhouette(NxVec3 lightPos, int lightIndex);
	
	GeGeometry* geometry;
	ShadowGeometry shadowGeometry;
};

#endif