#ifndef GEMESH_H
#define GEMESH_H
#include <list>
#include <NxPhysics.h>
#include "GeTexture.h"
#include "GeMaterial.h"
#include "GeNode.h"
#include "GeGeometry.h"
#include "GeMeshRenderer.h"
#include "GeAnimator.h"

class GeMesh : public GeNode, public std::list<GeMesh*> {
protected:
	float glMat[16];
	NxMat34 localPose;
	GeMeshRenderer* meshRenderer;
	GeTexture* texture;
	GeAnimator* animator;

	friend class GeAnimator;
	
	inline void renderOnly(void) {
		material.bind();
		if (texture != NULL) {
			texture->bind();
			meshRenderer->render();
		}
		else {
			GeTexture::unbind();
			meshRenderer->render();
		}
	};

public:
	GeMaterial material;

    GeMesh(GeMesh* mesh);
    GeMesh(GeGeometry* geometry);
    virtual ~GeMesh();
    
	void setTexture(GeTexture* texture);
	void setAnimator(int type);

	void render(void);
	void render(NxMat34 globalPose);
    void update(void);
	virtual void updateSingle(void) {};
	void setOutOfDate(void);
	void shadowPass(GeLight* light, NxMat34 globalPose);
};

#endif