#ifndef GELIGHT_H
#define GELIGHT_H
#include "oglheaders.h"
#include <NxPhysics.h>
#include "MVector3.h"
#include "MVector4.h"

class GeLight { //: public GeNode {
private:
	static int nextIndex;
	int index;
    bool valid;
	bool visible;
	bool active;
	float ac, al, aq;
	NxActor* actor;
	NxSphereShape* sphereShape;
	
public:
	MVector4 pos;

	GeLight(void);
	~GeLight(void);
	
	static void setGlobalAmbient(MColor3* amb);
	static void setGlobalAmbient(float r, float g, float b);
    
    void setDirectional(bool directional);
    void setPosition(float x, float y, float z);
    
    void setAttenuation(GLenum type, float value);
	void setAmbient(MColor3* amb);
	void setAmbient(float r, float g, float b);
	void setDiffuse(MColor4* diff);
	void setDiffuse(float r, float g, float b, float a);
	void setSpecular(MColor4* spec);
	void setSpecular(float r, float g, float b, float a);

	int getIndex();
	float getRadius();
	
	void show(void);
	void hide(void);
	bool isVisible(void);

	void activate(void);
	void deactivate(void);
	bool isActive(void);

	void render(void);
	void update(void);

};

#endif
