#ifndef GEHUDTEXT_H
#define GEHUDTEXT_H

#include "GeNode.h"
#include "Settings.h"
#include "oglheaders.h"

class GeHudText : public GeNode {
public:
	GeHudText(float posX, float posY, char* text, bool visible = true);
	~GeHudText();
	void render(void);
	void update(void);
	void shadowPass(GeLight* light) {};
	void setVisibility(bool value);
	void toggleVisibility();
	bool isVisible();
	void setFadOutText(char* text);

private:
	void centerText();
	GLvoid buildFont();
	GLvoid killFont();
	GLvoid glPrint(const char *fmt, ...);	

	GLuint base;
	float posX, posY;
	bool visible;
	float alpha;
	char* text;
	int textLength; 
	int counter;
};

#endif