#ifndef GEGEOMETRY_H
#define GEGEOMETRY_H
#include <list>

struct GeEdge {
	GLint vertexIndex[2];
	GLint triIndex[2];

	GeEdge reverseIndices() { 
		GeEdge result;
		result.vertexIndex[0] = vertexIndex[1];
		result.vertexIndex[1] = vertexIndex[0];
		return result;
	};
};

struct ShadowGeometry {
	GLdouble** verticesExtrude;
	bool** triLightFacing;
	unsigned char silhouetteUpToDate;
	std::list<GeEdge>* silhouetteEdges;
};

struct GeGeometry {
    GLdouble* vertices;
    GLdouble* normals;
	GLdouble* texcoord;				// texture coordinates
	GLdouble* normalsPoint;

	GeEdge* edges;
	GLuint vertexcount;	// number of vertices, normals and texture coordinates
	GLuint polygon_vertex_count;
	GLuint refcount;
	GLuint edgeCount;
	GLuint vboid;		// vertex buffer object id
	GLuint vbo_subdata_size;
	GLuint display_list_id;
	GLubyte display_list_mode;
};

#endif