#ifndef GECAMERA_H
#define GECAMERA_H
#include <NxPhysics.h>
#include "oglheaders.h"
#include "GeBranch.h"
#include "GeActor.h"
#include "MVector3.h"
#include "MInterpolate.h"

class GeCamera : public GeBranch {
private:
	NxShapeDesc* getViewFrustum(void);

	float zoom, totalDistance;
	float distance, sight; // distance and sight
	float viewAngle, viewRatio;

	NxVec3 t; // translation
	NxQuat orientation;
	float pitch, yaw;
	MInterpolate<float> *interYaw, *interZoom;
	MInterpolate<NxQuat>* interOrientation;

	float frustum[6][4];
	GLfloat orimat[16];
	NxShape* viewingVolume;
	
	void setupProjection(GLfloat viewAngle, GLfloat viewRatio);	
	
public:
	NxVec3 pos;
	NxActor* actor;

	GeCamera(float viewAngle, float viewRatio, float cameraDistance=6.0f, float sight=30.0f);
	~GeCamera(void);

	void renderSingle(void);
	void updateSingle(void);

	void changeOrientation(NxQuat q);
	void rotateStep(float dYaw, float dPitch);
	void rotateTo(float yaw);
};
#endif
