#ifndef GEACTOR_H
#define GEACTOR_H
#include <NxPhysics.h>
#include "GeMesh.h"

class GeActor : public GeMesh {
public:
	bool cull;
	bool castShadow;
	NxActor* actor;
	string id;

    GeActor(GeActor* mesh, int type=0);
    GeActor(GeGeometry* geometry, NxActor* actor);
    virtual ~GeActor();

	virtual void collide(GeActor* other, NxU32 events, NxContactPair* pair) {};

	virtual void render(void);
	void render(NxMat34 globalPose);
	virtual void shadowPass(GeLight* light);
    virtual void update(void);
};

#endif