#ifndef FBXCONVERTER_H
#define FBXCONVERTER_H
#include <fbxsdk.h>
#include "GeLight.h"
#include "GeActor.h"
#include "ActorPrototype.h"
#include "GeGeometry.h"
#include "PhysXWrapper.h"

class FBXConverter {
private:
	static void getGeometry(KFbxMesh* pMesh, KFbxXMatrix matrix, GeGeometry* geometry, GeTexture** tex);
	static void importChilds(KFbxNode* node, GeActor* actor);
	static void getShapes(KFbxNode* node, NxActorDesc* actorDesc, KFbxXMatrix globalPose);
	static NxConvexShapeDesc* cookConvex(KFbxMesh* mesh, KFbxXMatrix mat);
	static NxTriangleMeshShapeDesc * cookMesh(KFbxMesh* mesh, KFbxXMatrix mat);

public:
	static KFbxGeometryConverter* geomConverter;

	static GeMaterial getMaterial(KFbxMesh* pMesh);

	static GeLight* light(KFbxNode* node, KFbxXMatrix matrix);
	static Trigger* trigger(KFbxNode* node, KFbxXMatrix matrix);
	static ActorPrototype mesh(KFbxNode* node, KFbxXMatrix matrix, bool staticActor=false);
	static KFbxXMatrix getLocalTransformation(KFbxNode* pNode);
	static KFbxXMatrix getGeometricTransformation(KFbxNode* pNode);
};

#endif
