#ifndef CHARACTER_H
#define CHARACTER_H

#include <NxPhysics.h>
#include "GeActor.h"

#define MAX_WHEEL_SPEED 2000
#define WHEEL_ACCELERATION 100
#define COS45 0.7

class Character : public GeActor {
public:	
	Character(GeActor* mesh);
	~Character();
	
	void initActor();
	void render();	
	void shadowPass(GeLight* light);

	void jump(void);

	void update(void);
	void collide(GeActor* other, NxU32 events, NxContactPair* contactPair);

	bool autoCamera;
private:
	void UpdateWheelShapePos();

	bool jumping;
	NxVec3 contactNormal;
	bool updateOrientation;
	NxMaterial *material, *wsm;
	NxMat33 shapeLocalOrientation, wheelInitOrientation;
	NxShape* colShape;
	NxWheelShape* wheelShape;
	NxReal wheelShapeRollAngle;
	float wheelShapePoseMat[16];
};

#endif // CHARACTER_H