#include <stdio.h>
#include "../headers/Input.h"
#include "../headers/oglheaders.h"
#include "../headers/GeWindow.h"

// glutSetKeyRepeat(GLUT_KEY_REPEAT_OFF);

Settings* GeWindow :: s;
int GeWindow :: wid;

GeWindow :: GeWindow(Settings* set) {
	int mode;

	GeWindow::s = set;
	if(s->flags & FLAG_FULLSCREEN) {
		mode = GLFW_FULLSCREEN;
	} else {
		mode = GLFW_WINDOW;
	}
	// Parameters: width, height, redbits, greenbits, bluebits, alphabits, depthbits, stencilbits, mode
	if( !glfwOpenWindow(s->width, s->height, 0, 0, 0, 0, 16, 16, mode)) {
		printf("Could not create window");
		glfwTerminate();
	}
	glViewport(0, 0, s->width, s->height);
	
	glfwSetWindowTitle("Rota 1.0");
	//glutSetCursor(GLUT_CURSOR_NONE);
	glfwSetWindowSizeCallback(reshape);
	//glutReshapeFunc(reshape);
	glfwSwapInterval(0);
}

GeWindow :: ~GeWindow() {
	glfwCloseWindow();
	/*
	if (s->flags & FLAG_FULLSCREEN)
		glutLeaveGameMode();
	else
		glutDestroyWindow(wid);
	*/
}
/*
void GeWindow :: close(int exitCode) {
	glfwCloseWindow();
	/*
	if (s->flags & FLAG_FULLSCREEN)
		glutLeaveGameMode();
	else
		glutDestroyWindow(wid);
	*/
/*
	glfwTerminate();
	exit(exitCode);
}
*/


void GeWindow :: reshape(int width, int height) {
	double ratio = width/(double)height;

	if(ratio/s->viewRatio > 1) {
		s->width = width = (int)(height*s->viewRatio+0.5);
		s->height = height;
	} else {
		s->width = width;
		s->height = height = (int)(width/s->viewRatio+0.5);
	}
	
	s->halfWidth = width/2;
	s->halfHeight = height/2;
	
	glViewport(0, 0, s->width, s->height);

	//glutReshapeWindow(width, height);
	int pWidth;
	int pHeight;
	glfwGetWindowSize(&pWidth, &pHeight);
	if(pWidth != s->width || pHeight != s->height) {
		glfwSetWindowSize(s->width, s->height);
	}
	//Input::resetMousePos();
}
