#include "../headers/GeTransform.h"
#include "../headers/oglheaders.h"

GeTransform :: GeTransform (void) {
	s.x = s.y = s.z = 1.0f;
}

void GeTransform :: render(void) {
	glPushMatrix();
	GeBranch::render();
	glPopMatrix();
}

void GeTransform :: renderSingle(void) {
	glTranslatef(t.x,t.y,t.z);
	if (r.x != 0.0f) {
		glRotatef(r.x, 1.0f,0.0f,0.0f);
	}
	if (r.y != 0.0f) {
		glRotatef(r.y, 0.0f,1.0f,0.0f);
	}
	if (r.z != 0.0f) {
		glRotatef(r.z, 0.0f,0.0f,1.0f);
	}
	glScalef(s.x, s.y, s.z);
}
