#include "../headers/main.h"
#include "../headers/GeSortedBranch.h"

GeSortedBranch GeSortedBranch::instance;

void GeSortedBranch::add(GeBlendableMesh* mesh) {
	GeMeshProxy* proxy = new GeMeshProxy();
	bool inserted = false;

	proxy->mesh = mesh;
	proxy->qdist = mesh->actor->getGlobalPosition().distanceSquared(cam->pos);

	for (iterator i = instance.begin(); i != instance.end(); i++) {
		if ((*i)->qdist <= proxy->qdist) {
			instance.insert(i, proxy);
			inserted = true;
			break;
		}
	}
	if (!inserted) {
		instance.push_back(proxy);
	}
}

void GeSortedBranch::render(void) {
	if (!empty()) {
		glDisable(GL_CULL_FACE);
		for (iterator i = begin(); i != end(); i++) {
			(*i)->mesh->renderBlendable();
		}
		glEnable(GL_CULL_FACE);
	}
}

void GeSortedBranch::flush(void) {
	instance.resize(0);
};