#include "../headers/GeMaterial.h"

GeMaterial::GeMaterial(void) {
	ambient = MColor4(1.0f,1.0f,1.0f,1.0f);
	diffuse = MColor4(1.0f,1.0f,1.0f,1.0f);
	specular = MColor4(0.0f,0.0f,0.0f,1.0f);
	shininess = 0.0f;
}

GeMaterial::~GeMaterial() {
}

void GeMaterial::bind(void) {
	float* fambient = ambient;
	float* fdiffuse = diffuse;
	float* fspecular = specular;
	glMaterialfv(GL_FRONT, GL_AMBIENT, fambient);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, fdiffuse);
	glMaterialfv(GL_FRONT, GL_SPECULAR, fspecular);
	glMaterialf(GL_FRONT, GL_SHININESS, shininess);
	delete fambient;
	delete fdiffuse;
	delete fspecular;
}