#include "../headers/GeHudText.h"
#include "../headers/oglheaders.h"
#include "../headers/Settings.h"
#include <string.h>
#include <stdio.h>

GeHudText::GeHudText(float posX, float posY, char* text, bool visible) {
	this->posX = posX;
	this->posY = posY;
	this->text = text;
	this->alpha = 0.3;
	this->visible = visible;
	this->counter = -1;
	textLength = (int) strlen(text)+50;

	buildFont();
}

GeHudText::~GeHudText() {
	glDeleteLists(base, 96);
}

void GeHudText::render(void) {
	if(visible) {
		//printf("hudtext %d,%d: %s\n", (int)(settings.width*posX+0.5), (int)(settings.height*posY+0.5), text);		
		glColor4f(1.0, 1.0, 1.0, alpha);
		glWindowPos2i((int)(settings.width*posX+0.5), (int)(settings.height*posY+0.5));
		
		glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
		glListBase(base - 32);								// Sets The Base Character to 32
		glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
		glPopAttrib();										// Pops The Display List Bits
	}
}

void GeHudText::update(void) {
	if(counter > 0) {
		if(counter < 40) {
			alpha = alpha - 0.025f;
		}
		counter--;
	} else if(counter == 0) {
		this->visible = false;
	}
}

void GeHudText::setVisibility(bool value) {
	this->visible = value;
}

void GeHudText::toggleVisibility() {
	this->visible = !visible;
}

bool GeHudText::isVisible() {
	return visible;
}

void GeHudText::setFadOutText(char* text) {
	this->text = text;
	textLength = (int) strlen(text);
	centerText();
	counter = 70;
	alpha = 0.3;
	this->visible = true;
}

void GeHudText::centerText() {
	//posX = 0.5 - (glutBitmapLength(GLUT_BITMAP_HELVETICA_18, (unsigned char*)text))/(2.0*settings.width);
}

GLvoid GeHudText::buildFont(GLvoid)								// Build Our Bitmap Font
{
	HFONT	font;										// Windows Font ID
	HFONT	oldfont;									// Used For Good House Keeping

	base = glGenLists(96);								// Storage For 96 Characters

	font = CreateFont(	-24,							// Height Of Font
						0,								// Width Of Font
						0,								// Angle Of Escapement
						0,								// Orientation Angle
						FW_BOLD,						// Font Weight
						FALSE,							// Italic
						FALSE,							// Underline
						FALSE,							// Strikeout
						ANSI_CHARSET,					// Character Set Identifier
						OUT_TT_PRECIS,					// Output Precision
						CLIP_DEFAULT_PRECIS,			// Clipping Precision
						ANTIALIASED_QUALITY,			// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,		// Family And Pitch
						"Arial Black");					// Font Name
	
	// Retrieve the window handle
    HWND hWnd = FindWindow("GLFW", NULL);
    // Retrieve the device context
	HDC	hDC = GetDC(hWnd);
	oldfont = (HFONT)SelectObject(hDC, font);           // Selects The Font We Want
	wglUseFontBitmaps(hDC, 32, 96, base);				// Builds 96 Characters Starting At Character 32
	SelectObject(hDC, oldfont);							// Selects The Font We Want
	DeleteObject(font);									// Delete The Font
}

GLvoid GeHudText::killFont() {
 	glDeleteLists(base, 96);
}