#include "../headers/GeBranch.h"

void GeBranch :: render(void) {
	renderSingle();
	if (!empty()) {
		for (iterator i = begin(); i != end(); i++) {
			if((*i)->visible) {
				(*i)->render();
			}
		}
	}
	postRender();
}

void GeBranch :: update(void) {
	updateSingle();
	if (!empty()) {
		for (iterator i = begin(); i != end(); i++) {
			(*i)->update();
		}
	}
}

void GeBranch :: shadowPass(GeLight* light) {
	if (!empty()) {
		for (iterator i = begin(); i != end(); i++) {
			(*i)->shadowPass(light);
		}
	}
}

void GeBranch :: renderSingle(void) {}
void GeBranch :: updateSingle(void) {}
void GeBranch :: postRender(void) {}
