#include "../headers/Settings.h"
#include "../headers/GeBlendableMesh.h"
#include "../headers/GeSortedBranch.h"

GeBlendableMesh :: GeBlendableMesh(GeActor* mesh, int type) : GeActor(mesh, type) {
}

GeBlendableMesh :: GeBlendableMesh(GeGeometry* geometry, NxActor* actor) : GeActor(geometry, actor) {
}

GeBlendableMesh :: ~GeBlendableMesh() {
	GeActor :: ~GeActor();
}

void GeBlendableMesh :: render(void) {
	if ((settings.flags & FLAG_TRANSPARENCY) == 0) {
		GeActor::render();
	}
}

void GeBlendableMesh :: renderBlendable(void) {
	GeActor::render();
}

void GeBlendableMesh :: update(void) {
	if ((settings.flags & FLAG_TRANSPARENCY) != 0) {
		GeSortedBranch::add(this);
	}
}