#include "../headers/GeAnimator.h"

GeAnimator :: GeAnimator(NxMat34* mat, int type) {
	this->mat = mat;
	NxQuat anim = NxQuat(0.0f, NxVec3(1.0f, 0.0f, 0.0f));
	if ((type & ANIMATOR_ROT_X) != 0) {
		anim *= NxQuat(ANIMATOR_ANGLE_STEP, NxVec3(1.0f, 0.0f, 0.0f));
	}
	if ((type & ANIMATOR_ROT_Y) != 0) {
		anim *= NxQuat(ANIMATOR_ANGLE_STEP, NxVec3(0.0f, 1.0f, 0.0f));
	}
	if ((type & ANIMATOR_ROT_Z) != 0) {
		anim *= NxQuat(ANIMATOR_ANGLE_STEP, NxVec3(0.0f, 0.0f, 1.0f));
	}
	animationStep.fromQuat(anim);
	this->type = type;
}

GeAnimator :: ~GeAnimator() {
}


void GeAnimator :: update(void) {
	mat->M = mat->M*animationStep;
}
