#include "../headers/Settings.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


void Settings::saveSettings() {
	FILE* fp;
	fp = fopen("config.ini", "r+");
	if (fp == NULL) {
		fp = fopen("config.ini", "w");

		fprintf(fp, ";General Settings\n\n");

		fprintf(fp, ";Mipmap-Modes: 0=Off, 1=Billinear, 2=Trillinear\n");
		fprintf(fp, "mipmapMode=%u\n", mipmapMode);
		fprintf(fp, ";Render-Modes: 0=immediate mode, 1=vertex arrays, 2=vbo\n");
		fprintf(fp, "renderMode=%u\n\n", renderMode);

		fprintf(fp, "width=%u\n", width);
		fprintf(fp, "height=%u\n\n", height);

		fprintf(fp, "depth=%u\n", depth);
		fprintf(fp, "frequency=%u\n\n", frequency);

		fprintf(fp, ";Flags\n");
		fprintf(fp, "fullscreen=%u\n", (flags & FLAG_FULLSCREEN) != 0);
		fprintf(fp, "showFps=%u\n", (flags & FLAG_SHOW_FPS) != 0);
		fprintf(fp, "wireFrame=%u\n", (flags & FLAG_WIREFRAME) != 0);
		fprintf(fp, "texturequalityHigh=%u\n", (flags & FLAG_TEXTUREQUALITY_HIGH) != 0);
		fprintf(fp, "viewfrustumCulling=%u\n", (flags & FLAG_VIEWFRUSTUM_CULLING) != 0);
		fprintf(fp, "Transparency=%u\n", (flags & FLAG_TRANSPARENCY) != 0);
		fprintf(fp, "showBounding=%u\n", (flags & FLAG_SHOW_BOUNDING) != 0);
		fprintf(fp, "usingShader=%u\n", (flags & FLAG_USE_CUSTOM_SHADER) != 0);
		fprintf(fp, "showVolumeShadows=%u\n", (flags & FLAG_VOLUME_SHADOWS) != 0);
				
	} else {
		//fprintf(fp, "");
	}
	
	fclose(fp);
}

bool Settings::loadSettings() {
	bool result = false;
	loadDefaultSettings();

	FILE* fp;
	fp = fopen("config.ini", "r");
	if(fp != NULL) {
		int val = 0;
		val = getIntByVal(fp, "mipmapMode");
		if(val >= 0 && val <= 2) {
			mipmapMode = val;
		}
		val = getIntByVal(fp, "renderMode");
		if(val >= 0 && val <= 255) {
			renderMode = val;
		}
		val = getIntByVal(fp, "width");
		if(val >= 50 && val <= 1680) {
			width = val;
		}
		val = getIntByVal(fp, "height");
		if(val >= 50 && val <= 1200) {
			height = val;
		}
		val = getIntByVal(fp, "depth");
		if(val >= 8 && val <= 32) {
			depth = val;
		}
		val = getIntByVal(fp, "frequency");
		if(val >=5 && val <=200) {
			frequency = val;
		}
		flags = 0;

		val = getIntByVal(fp, "fullscreen");
		if(val > 0) {
			flags = flags | FLAG_FULLSCREEN;
		} 

		val = getIntByVal(fp, "showFps");
		if(val > 0) {
			flags = flags | FLAG_SHOW_FPS;
		}

		val = getIntByVal(fp, "wireFrame");
		if(val > 0) {
			flags = flags | FLAG_WIREFRAME;
		} 

		val = getIntByVal(fp, "texturequalityHigh");
		if(val > 0) {
			flags = flags | FLAG_TEXTUREQUALITY_HIGH;
		} 

		val = getIntByVal(fp, "viewfrustumCulling");
		if(val > 0) {
			flags = flags | FLAG_VIEWFRUSTUM_CULLING;
		} 

		val = getIntByVal(fp, "transparency");
		if(val > 0) {
			flags = flags | FLAG_TRANSPARENCY;
		} 

		val = getIntByVal(fp, "showBounding");
		if(val > 0) {
			flags = flags | FLAG_SHOW_BOUNDING;
		} 

		val = getIntByVal(fp, "usingShader");
		if(val > 0) {
			flags = flags | FLAG_USE_CUSTOM_SHADER;
		} 

		val = getIntByVal(fp, "showVolumeShadows");
		if(val > 0) {
			flags = flags | FLAG_VOLUME_SHADOWS;
		} 

		fclose(fp);
			
		viewRatio = width/(float)height;
		
		result = true;
	} else {
		saveSettings();
	}

	return result;
}

void Settings::loadDefaultSettings() {
	width = 1024;
	height = 768;
	viewRatio = 4.0f/3.0f;
	depth = 32;
	frequency = 60;
	updateInterval = 20;
	flags = FLAG_TEXTUREQUALITY_HIGH | FLAG_USE_CUSTOM_SHADER | FLAG_VOLUME_SHADOWS | FLAG_TRANSPARENCY; // | FLAG_FULLSCREEN;
	mipmapMode = MIPMAP_MODE_LIN;
	renderMode = RENDER_IMMEDIATE;
}

int Settings::getIntByVal(FILE* fp, char* key) {
	char res[128];
	getValueByKey(fp, res, key);
	return strtol(res, NULL, 10);
}

void Settings::getValueByKey(FILE* fp, char* val, char* key) {
	
	//fread(buffer, 1, 1024, fp);

	while(!feof(fp)) {
		char str[128];
		fgets(str, 128, fp);

		if(str[0] != ';') {
			char *ptr = strstr(str, key);
			if(ptr != NULL) {
				if(ptr != str && ptr[-1] != ' ') {
					continue;
				}
				ptr = strstr(ptr, "=");
				if(ptr != NULL) {
					strcpy(val, ptr+1);
					break;
				}
			}
		}
	}
	fseek(fp, 0, SEEK_SET);
}