#include "../headers/MeshManager.h"
#include "../headers/PhysXWrapper.h"
#include "../headers/main.h"

MeshManager :: MeshManager(string folder) {
	this->folder = folder;
}

MeshManager :: ~MeshManager() {
	actorMap.clear();
}


GeActor* MeshManager :: getActor(string name, bool staticActor) {
	GeActor* ret = NULL;
	if(actorMap.count(name) > 0) {
		ret = new GeActor(actorMap[name].actor);
		ret->actor = physx.scene->createActor(*(actorMap[name].actorDesc));
		ret->actor->userData = ret;
	}
	else {
		ActorPrototype actorProt = fbx.importMesh((folder+name+string(".FBX")).data(), staticActor);
		if (actorProt.actor != NULL) {
			actorMap[name] = actorProt;
			ret = actorMap[name].actor;
		}
		else ret = NULL;
	}
	return ret;
}

GeBlendableMesh* MeshManager :: getBlendableActor(string name, bool staticActor) {
	GeBlendableMesh* ret = NULL;
	if(actorMap.count(name) > 0) {
		ret = new GeBlendableMesh(actorMap[name].actor);
		ret->actor = physx.scene->createActor(*(actorMap[name].actorDesc));
		ret->actor->userData = ret;
	}
	else {
		ActorPrototype actorProt = fbx.importMesh((folder+name+string(".FBX")).data(), staticActor);
		if (actorProt.actor != NULL) {
			actorMap[name] = actorProt;
			ret = new GeBlendableMesh(actorMap[name].actor);
		}
		else ret = NULL;
	}
	return ret;
}
